%------------------------------------------------------------------------------
% File     : GEG009^1 : TPTP v7.4.0. Released v4.1.0.
% Domain   : Geography
% Problem  : Something about Paris and Spain
% Version  : [RCC92] axioms.
% English  : 

% Refs     : [RCC92] Randell et al. (1992), A Spatial Logic Based on Region
%          : [Ben10a] Benzmueller (2010), Email to Geoff Sutcliffe
%          : [Ben10b] Benzmueller (2010), Simple Type Theory as a Framework
% Source   : [Ben10a]
% Names    : Problem 68 [Ben10b]

% Status   : Theorem
% Rating   : 0.29 v7.4.0, 0.44 v7.2.0, 0.38 v7.1.0, 0.62 v7.0.0, 0.57 v6.4.0, 0.50 v6.3.0, 0.40 v6.2.0, 0.71 v5.5.0, 0.67 v5.4.0, 0.60 v5.3.0, 0.80 v5.1.0, 1.00 v5.0.0, 0.80 v4.1.0
% Syntax   : Number of formulae    :   98 (   0 unit;  49 type;  40 defn)
%            Number of atoms       :  363 (  45 equality; 184 variable)
%            Maximal formula depth :   11 (   6 average)
%            Number of connectives :  236 (  12   ~;   4   |;  19   &; 191   @)
%                                         (   0 <=>;  10  =>;   0  <=;   0 <~>)
%                                         (   0  ~|;   0  ~&)
%            Number of type conns  :  195 ( 195   >;   0   *;   0   +;   0  <<)
%            Number of symbols     :   53 (  49   :;   0   =)
%            Number of variables   :  117 (   7 sgn;  33   !;  10   ?;  74   ^)
%                                         ( 117   :;   0  !>;   0  ?*)
%                                         (   0  @-;   0  @+)
% SPC      : TH0_THM_EQU_NAR

% Comments : 
%------------------------------------------------------------------------------
%----Include Region Connection Calculus axioms
include('Axioms/LCL013^0.ax').
include('Axioms/LCL014^0.ax').
%------------------------------------------------------------------------------
thf(catalunya,type,(
    catalunya: reg )).

thf(france,type,(
    france: reg )).

thf(spain,type,(
    spain: reg )).

thf(paris,type,(
    paris: reg )).

thf(a,type,(
    a: $i > $i > $o )).

thf(fool,type,(
    fool: $i > $i > $o )).

thf(t_axiom_for_fool,axiom,
    ( mvalid
    @ ( mforall_prop
      @ ^ [A: $i > $o] :
          ( mimplies @ ( mbox @ fool @ A ) @ A ) ) )).

thf(k_axiom_for_fool,axiom,
    ( mvalid
    @ ( mforall_prop
      @ ^ [A: $i > $o] :
          ( mimplies @ ( mbox @ fool @ A ) @ ( mbox @ fool @ ( mbox @ fool @ A ) ) ) ) )).

thf(i_axiom_for_fool_a,axiom,
    ( mvalid
    @ ( mforall_prop
      @ ^ [Phi: $i > $o] :
          ( mimplies @ ( mbox @ fool @ Phi ) @ ( mbox @ a @ Phi ) ) ) )).

thf(ax1,axiom,
    ( mvalid
    @ ( mbox @ a
      @ ^ [X: $i] :
          ( tpp @ catalunya @ spain ) ) )).

thf(ax2,axiom,
    ( mvalid
    @ ( mbox @ fool
      @ ^ [X: $i] :
          ( ec @ spain @ france ) ) )).

thf(ax3,axiom,
    ( mvalid
    @ ( mbox @ a
      @ ^ [X: $i] :
          ( ntpp @ paris @ france ) ) )).

thf(con,conjecture,
    ( mvalid
    @ ( mbox @ a
      @ ^ [X: $i] :
        ? [Z: reg] :
          ( ~ ( o @ Z @ paris )
          & ~ ( eq @ Z @ spain ) ) ) )).

%------------------------------------------------------------------------------
